<?php
/*
Plugin Name: Reddit RSS Dashboard Widget
Plugin URI: http://www.re-cycledair.com
Description: Displays the first 10 items of Reddit's RSS feed in your dashboard.
Version: 0.1
Author: Jack Slingerland
Author URI: http://www.re-cycledair.com
*/


//Function to display the RSS feed.
function reddit_rss_dashboard_widget_function() {
	$rss = fetch_feed( "http://www.reddit.com/.rss" );

	if ( is_wp_error($rss) ) {
		if ( is_admin() || current_user_can('manage_options') ) {
			echo '<p>';
			printf(__('<strong>RSS Error</strong>: %s'), $rss->get_error_message());
			echo '</p>';
		}
		return;
	}

	if ( !$rss->get_item_quantity() ) {
		echo '<p>Apparently, there is nothing happening on Reddit!</p>';
		$rss->__destruct();
		unset($rss);
		return;
	}

	echo "<ul>\n";

	if ( !isset($items) )
		$items = 10;

	foreach ( $rss->get_items(0, $items) as $item ) {
		$publisher = '';
		$site_link = '';
		$link = '';
		$content = '';
		$date = '';
		$link = esc_url( strip_tags( $item->get_link() ) );

		$content = $item->get_content();
		$content = wp_html_excerpt($content, 250) . ' ...';

		echo "\t<li><a href='$link'>$link</a> - $content</li>\n";
	}

	echo "</ul>\n";
	$rss->__destruct();
	unset($rss);
};

//Function to add the rss feed to the dashboard.
function reddit_rss_add_dashboard_widget() {
	wp_add_dashboard_widget('reddit_rss_dashboard_widget', 'Reddit RSS', 'reddit_rss_dashboard_widget_function');
}

//Action that calls the function that adds the widget to the dashboard.
add_action('wp_dashboard_setup', 'reddit_rss_add_dashboard_widget');
?>